<?php
// Atur timezone ke Jakarta
date_default_timezone_set('Asia/Jakarta');
require_once __DIR__ . '/config.php';

// Fungsi kirim pesan Telegram tanpa pratinjau
function sendTelegram($botToken, $chatId, $message) {
    $url = "https://api.telegram.org/bot$botToken/sendMessage";
    $data = [
        'chat_id' => $chatId,
        'text' => $message,
        'parse_mode' => 'HTML',
        'disable_web_page_preview' => true // ⬅️ hilangkan pratinjau website
    ];

    $options = [
        'http' => [
            'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
            'method'  => 'POST',
            'content' => http_build_query($data),
        ],
    ];
    $context  = stream_context_create($options);
    file_get_contents($url, false, $context);
}

// ========== Fungsi Cek Website ==========
function checkSite($url, $timeout = 10) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, $timeout);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);

    $output = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $errorMsg = '';

    if (curl_errno($ch)) {
        $errorMsg = curl_error($ch);
    }

    curl_close($ch);

    if ($httpCode >= 200 && $httpCode < 400) {
        return [true, $httpCode, null]; // Site UP
    } else {
        return [false, $httpCode, $errorMsg ?: "HTTP Error {$httpCode}"];
    }
}

// ========== Eksekusi Monitoring ==========
if (!file_exists($baseDir)) {
    mkdir($baseDir, 0777, true);
}

foreach ($sites as $siteName => $siteUrl) {
    $slug = preg_replace('/[^a-z0-9]+/i', '_', parse_url($siteUrl, PHP_URL_HOST));
    $stateFile = "{$baseDir}/state_{$slug}.txt";
    $logFile   = "{$baseDir}/log_" . date("Y-m-d") . ".txt"; // ✅ per hari, bukan per jam

    list($up, $statusCode, $errorMsg) = checkSite($siteUrl, $timeout);

    $last = file_exists($stateFile) ? trim(file_get_contents($stateFile)) : '';
    $state = $up ? 'up' : 'down';
    $timestamp = date("d/m/Y H:i:s");

    $logText = "[{$timestamp}] {$siteName} ({$siteUrl}) | {$state} | status {$statusCode} | {$errorMsg}\n";
    file_put_contents($logFile, $logText, FILE_APPEND);

    if ($state !== $last) {
        if ($up) {
            $msg = "✅ <b>SITE UP</b>\nNama: {$siteName}\nURL: {$siteUrl}\nStatus: {$statusCode}\n⏰ Waktu: {$timestamp}";
        } else {
            $msg = "❌ <b>SITE DOWN</b>\nNama: {$siteName}\nURL: {$siteUrl}\nStatus: {$statusCode}\nPenyebab: {$errorMsg}\n⏰ Waktu: {$timestamp}";
        }

        // kirim ke semua chat id (array dari config.php)
        foreach ($chatIds as $cid) {
            sendTelegram($botToken, $cid, $msg);
        }

        file_put_contents($stateFile, $state);
    }
}
