<?php
require __DIR__ . "/config.php";

// ============ FUNCTION KIRIM TELEGRAM ============
function sendTelegram($botToken, $chatId, $text) {
    $url = "https://api.telegram.org/bot{$botToken}/sendMessage";
    $data = [
        "chat_id" => $chatId,
        "text" => $text,
        "parse_mode" => "HTML",
        "disable_web_page_preview" => true
    ];

    $options = [
        "http" => [
            "header"  => "Content-type: application/x-www-form-urlencoded\r\n",
            "method"  => "POST",
            "content" => http_build_query($data),
            "timeout" => 10
        ]
    ];
    $context  = stream_context_create($options);
    return @file_get_contents($url, false, $context);
}

// ============ RANGKUMAN ============
$today = date("Y-m-d");
$logFile = "{$baseDir}/log_{$today}.txt";

if (!file_exists($logFile)) {
    die("Belum ada log hari ini.\n");
}

$lines = file($logFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

$summary = "📊 <b>Summary Website Monitoring</b>\n🗓️ Tanggal: {$today}\n\n";
$currentStatus = [];

foreach ($sites as $siteName => $siteUrl) {
    $slug = preg_replace('/[^a-z0-9]+/i', '_', parse_url($siteUrl, PHP_URL_HOST));
    $stateFile = "{$baseDir}/state_{$slug}.txt";
    $status = file_exists($stateFile) ? trim(file_get_contents($stateFile)) : "unknown";
    $icon = $status === "up" ? "✅ UP" : ($status === "down" ? "❌ DOWN" : "❓ UNKNOWN");
    $currentStatus[] = "📛 {$siteName}\n🌐 {$siteUrl}\n📡 {$icon}";
}

$summary .= implode("\n\n", $currentStatus);

sendTelegram($botToken, $chatId, $summary);
